export type Type = string;

export type Version = string;

export type Title = string;

export type Author = string;

export type Id = number;

export type Label = string;

export type Icon = string;

export type Width = number;

export type Height = number;

export type HorizontalPosition = number;

export type VerticalPosition = number;

export enum Visualization {
    AreaChart = "areaChart",
    BarChart = "barChart",
    PieChart = "pieChart",
    Table = "table",
    Text = "text",
    TreemapChart = "treemapChart",
    RadialBarChart = "radialBarChart",
    TwoSidedBarChart = "twoSidedBarChart",
    DonutChart = "donutChart",
}

export type OptionTitle = string;

export type NumberOption = {
    type: "number";
    value: number;
    title: OptionTitle;
};

export type TextOption = {
    type: "text";
    value: string;
    title: OptionTitle;
};

export type DropdownOptionItems = { [key: string]: string };

export type DropdownOption = {
    type: "dropdown";
    value: string;
    title: OptionTitle;
    dropdown: DropdownOptionItems;
};

export type CheckboxOption = {
    type: "checkbox";
    value: boolean;
    title: OptionTitle;
};

export type Option = NumberOption | TextOption | DropdownOption | CheckboxOption;

export type Options = { [key: string]: Option };

export type SerialDataCategories = string[];

export type SerialDataItemValues = number[];

export type SerialDataItem = {
    title: string;
    values: SerialDataItemValues;
};

export type SerialDataItems = SerialDataItem[];

export type SerialData = {
    type: "serial";
    categories: SerialDataCategories;
    series: SerialDataItems;
};

export type MapDataValue = {
    title: string;
    value: number;
};

export type MapDataValues = MapDataValue[];

export type MapData = {
    type: "map";
    values: MapDataValues;
};

export type TextValue = string;

export type TextData = {
    type: "text";
    value: TextValue;
};

export type NumberData = {
    type: "number";
    value: NumberValue;
};

export type NumberValue = string;

export type TableDataColumnTitle = string;

export type TableDataColumnField = string;

export type TableDataBooleanColumn = {
    type: "boolean";
    title: TableDataColumnTitle;
    field: TableDataColumnField;
};

export type TableDataDateColumnFormat = {
    input: string;
    output: string;
};

export type TableDataDateColumn = {
    type: "date";
    title: TableDataColumnTitle;
    field: TableDataColumnField;
    format: TableDataDateColumnFormat;
};

export type TableDataDecimalColumn = {
    type: "decimal";
    title: TableDataColumnTitle;
    field: TableDataColumnField;
};

export type TableDataIntegerColumn = {
    type: "integer";
    title: TableDataColumnTitle;
    field: TableDataColumnField;
};

export type TableDataPercentageColumn = {
    type: "percentage";
    title: TableDataColumnTitle;
    field: TableDataColumnField;
};

export type TableDataTextColumn = {
    type: "text";
    title: TableDataColumnTitle;
    field: TableDataColumnField;
};

export type TableDataColumn =
    | TableDataBooleanColumn
    | TableDataDateColumn
    | TableDataDecimalColumn
    | TableDataIntegerColumn
    | TableDataPercentageColumn
    | TableDataTextColumn;

export type TableDataColumns = TableDataColumn[];

export type TableDataRowStringField = string;

export type TableDataRowNumberField = number;

export type TableDataRowBooleanField = boolean;

export type TableDataRowField = TableDataRowStringField | TableDataRowNumberField | TableDataRowBooleanField;

export type TableDataRow = { [key: string]: TableDataRowField };

export type TableDataRows = TableDataRow[];

export type TableData = {
    type: "table";
    columns: TableDataColumns;
    rows: TableDataRows;
};

export type Data = SerialData | MapData | TextData | TableData | NumberData;

export type UpdateSetValue = string | number | boolean;

export type OptionUpdateSet = {
    [key: string]: UpdateSetValue;
};

export interface Widget {
    id: Id;
    label: Label;
    icon: Icon;
    width: Width;
    height: Height;
    horizontalPosition: HorizontalPosition;
    verticalPosition: VerticalPosition;
    visualization: Visualization;
    options: Options;
    data: Data;
}

export type Widgets = Widget[];

export interface AvailableWidget {
    type: Type;
    version: Version;
    title: Title;
    icon: Icon;
    author: Author;
}

export type AvailableWidgets = AvailableWidget[];

export type PageKey = number;

export type PageStyle = { width: string; height: string };

export interface PageTranslations {
    language_code: string;
    overview_page_title: string;
    overview_add_widget: string;
    overview_all_widgets: string;
    overview_cancel: string;
    overview_edit_widget: string;
    overview_save: string;
    overview_widget_label: string;
    overview_erroneous_widget: string;
    overview_refresh: string;
    overview_widget_without_data: string;
    overview_error_occurred: string;
    overview_manage: string;
    overview_lock_dashboard: string;
    overview_unlock_dashboard: string;
    overview_empty_state_heading: string;
    overview_empty_state_subtext: string;
    overview_search_label: string;
    overview_refresh_interval_none: string;
    overview_refresh_interval_every: string;
    overview_refresh_interval_seconds: string;
    overview_refresh_interval_minute: string;
    overview_refresh_interval_minutes: string;
    overview_refresh_interval_hour: string;
    overview_delete_widget: string;
    overview_delete_widget_confirmation: string;
}

export type UnselectedWidget = {};

export type UnselectedAvailableWidget = {};

export type NoErrorMessage = "";

export type EmptySearchTerm = "";

export type UnselectedRefreshInterval = 0;

export type ModalOpenState = boolean;

export type LoadingState = boolean;

export type LockedState = boolean;

export type DraggingState = boolean;

export type Color = string;

export type ColorPalette = Color[];

export type ErrorMessage = string;

export type SearchTerm = string;

export type RefreshInterval = number;

export type RefreshIntervals = RefreshInterval[];

export type RefreshButtonDropupOpenState = boolean;

export type RefreshButtonDropupItemTitle = string;

export type RefreshButtonDropupItemValue = RefreshInterval;

export interface RefreshButtonDropupItem {
    title: RefreshButtonDropupItemTitle;
    value: RefreshButtonDropupItemValue;
}

export type RefreshButtonDropupItems = RefreshButtonDropupItem[];

export type RefreshIntervalLoop = number | undefined;
